/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/


#ifndef DEFINES_H_INCLUDED
#define DEFINES_H_INCLUDED

/* ******************************************************************

     Important Note!!

     You may have problems compiling code that depends on our
     definition of the HUGE ppc constant. Some compilers define
     HUGE to HUGE_VAL in their <math.h>. To avoid this, you should
     work with a private copy of <math.h> where you disable or
     delete the definition of the HUGE constant. It took me an
     afternoon to find out and fix it.

     **************************************************************** */


/*
_WIN32 is auto-defined by MS (WIN32 not)
*/

#if defined(_WIN32) && !defined(WIN32)
#	define WIN32
#endif

#if defined(_WIN64) && !defined(WIN64)
#	define WIN64
#endif

/* 
Note;	if you have a problem with the strict ANSI __ (double-underscore)
		then use _ (single-underscore). i.e. _export instead of __export 
*/

#undef EXPORT
#undef IMPORT
#undef LOADDS
#undef HUGE
#undef far

#if defined(WIN32) || defined(WIN64)
#	ifdef _MSC_VER		/* microsoft Win32 compilers only */
#		ifdef BEST_SUPPORT	
#			define EXPORT _stdcall
#		else
#                       define EXPORT __declspec(dllexport)
#                       define IMPORT __declspec(dllimport)
#		endif
#	else
#		define EXPORT __export
#	endif
#	define LOADDS
#	define HUGE
#	define far

#elif defined DOS		/* dos or win16 */
#	define EXPORT __export	
#	define LOADDS __loadds
#	define HUGE __huge
#	define far	_far

#else
#	define EXPORT
#	define LOADDS
#	define HUGE
#	define far
#       define IMPORT
#endif


#define CLI

#ifdef COMPILING_MISC
# define MISC_IMPORTEXPORT EXPORT
#else
# define MISC_IMPORTEXPORT IMPORT
#endif

#ifdef COMPILING_HWARE
# define HWARE_IMPORTEXPORT EXPORT
#else
# define HWARE_IMPORTEXPORT IMPORT
#endif

#ifdef COMPILING_XACT
# define XACT_IMPORTEXPORT EXPORT
#else
# define XACT_IMPORTEXPORT IMPORT
#endif

#endif /* DEFINES_H_INCLUDED */

